#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BloodBankAccessionArea : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		} 

		private BloodBankAccessionArea GetTestAccessionArea()
		{
			IEnumerator _en = BloodBankAccessionArea.GetAllSortedByName().GetEnumerator();
			_en.MoveNext();

			return (BloodBankAccessionArea)_en.Current;
		}

		[Test]
		public void ID_Pass()
		{
			Assert.IsTrue( GetTestAccessionArea().ID > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ID_Fail() {}

		[Test]
		public void Name_Pass()
		{
			Assert.IsNotNull( GetTestAccessionArea().Name );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Name_Fail(){}

		[Test]
		public void GetAllSortedByName_Pass()
		{
			BOL.BusinessObjectSortedHashList tstObj = BOL.BloodBankAccessionArea.GetAllSortedByName();

			Assert.IsTrue(tstObj.ToString().Length > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllSortedByName_Fail(){}

		[Test]
		public void GetObjectID_Pass()
		{
			Assert.IsTrue(GetTestAccessionArea().ID == (int)GetTestAccessionArea().GetObjectID());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetObjectID_Fail(){}

	}
}

#endif
